// DISingleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DISingle.h"
#include "DISingleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDISingleDlg dialog

CDISingleDlg::CDISingleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDISingleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDISingleDlg)
	m_DIValue = _T("");
	m_device = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDISingleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDISingleDlg)
	DDX_Control(pDX, IDC_READ, m_readButton);
	DDX_Control(pDX, IDC_INIT, m_initButton);
	DDX_Text(pDX, IDC_DIVALUE, m_DIValue);
	DDX_Text(pDX, IDC_DEVICE, m_device);
	DDV_MinMaxUInt(pDX, m_device, 0, 5);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDISingleDlg, CDialog)
	//{{AFX_MSG_MAP(CDISingleDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_READ, OnRead)
	ON_BN_CLICKED(IDC_INIT, OnInit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDISingleDlg message handlers

BOOL CDISingleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_pSR=NULL;  // set our pointers equal to something
    m_driverInstance=NULL;
	m_device = 0;
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDISingleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDISingleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDISingleDlg::OnClose() 
{
	// code to clean up after DriverLINX
CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
m_driverInstance=NULL; //make sure m_driverInstance isn't pointing to anything
delete(m_pSR); //de-allocate the memory used by the service request
m_pSR=NULL;
	// pass the message on
	CDialog::OnClose();
}

void CDISingleDlg::OnRead() 
{
	// setup a single channel, polled mode DI task
	m_pSR->mode = POLLED;
	m_pSR->operation = START;
	m_pSR->subsystem = DI;
	m_pSR->start.typeEvent = COMMAND;
	m_pSR->stop.typeEvent = TCEVENT;
	m_pSR->timing.typeEvent = NULLEVENT;
	m_pSR->channels.nChannels = 1;  // only one channel
	m_pSR->channels.chanGain[0].channel = 0;   // DI channel 0
		m_pSR->channels.numberFormat = tNATIVE;  // native format, e.g., byte
	if (DriverLINX(m_pSR) == NoErr)
	{  // success
		m_DIValue.Format("%d",m_pSR->status.u.ioValue);
		UpdateData(FALSE); // update the Dialog
		/* status.u.ioValue member of the SR structure can host single value input/output
		   tasks.  No need to allocate and use a buffer when doing single value I/O tasks
         
		   The DAS-800 Series have only 3 digital I/O lines.  Value will be between
		   0 and 7.  (7 = all at logic 1)
		   They have pullup resistors so will be at logic 1 state if floating.
		   Touch them to ground to change them to logic 0 state.

           

		*/
	}
    else  // problem has occured
	{  showMessage(m_pSR);}  // display the error message box
	
	
}

void CDISingleDlg::OnInit() 
{
	 // Open the driver and Initialize the hardware

// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance=OpenDriverLINX(m_hWnd,"kmb800"); //Open DriverLINX driver

UpdateData(TRUE);  // get device number data from the dialog
// pass in driver name to avoid the dialog box to pick a driver
m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
m_pSR->device=m_device; //set the device number to the device being used
m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application
//Execute the initialize service
 //show any errors	

if (DriverLINX(m_pSR) == NoErr)
{
	// success
m_readButton.EnableWindow(TRUE);  // enable the Read button
}
else
{  // problem has occured
showMessage(m_pSR);  // display the error message box
}
CWnd::SetActiveWindow();  // set focus back to our dialgo	
}

void CDISingleDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
	return;
}
